<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../session.php"; 
include 'conect.php';
date_default_timezone_set('America/Guatemala');

// Establecer conexión con la base de datos
$connection = new mysqli($hostname, $username, $pass, $database);

// Verificar si la conexión fue exitosa
if ($connection->connect_error) {
    die("Error de conexión: " . $connection->connect_error);
}

// Ruta y nombre de archivo para la copia de seguridad
$backupDir="../backup/";  // Cambia esto por la ruta donde deseas guardar la copia de seguridad
$dateCodeBackup = date("YmdHis");
$backupFile = $backupDir . $dateCodeBackup . "_Backup_du.sql";

echo $backupFile;

// Obtener el contenido de la base de datos
$query = "SELECT * FROM ventas"; // Cambia "tabla" por el nombre de tu tabla
$result = $connection->query($query);

if ($result) {
    // Verificar si el directorio de respaldo existe, si no, crearlo
if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true); // 0755 para permisos de lectura y escritura
}

// Abrir archivo de copia de seguridad
$file = fopen($backupFile, 'w');

    if ($file) {
        // Escribir datos en el archivo
        while ($row = $result->fetch_assoc()) {
            fwrite($file, implode(',', $row) . "\n");
        }

        fclose($file);
        echo "Copia de seguridad generada correctamente en: $backupFile";
    } else {
        echo "Error al abrir el archivo de copia de seguridad.";
    }
} else {
    echo "Error al obtener los datos de la base de datos: " . $connection->error;
}



// Cerrar la conexión
$connection->close();




?>
