<?php

$printers = [];
try {
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
    $output = shell_exec('wmic printer get Name');
    $lines = explode("\n", trim($output));
    foreach ($lines as $index => $line) {
        $printer = trim($line);
        if ($index > 0 && !empty($printer) && $printer !== 'Name') {
            $printers[] = $printer;
        }
    }
} elseif (strtoupper(PHP_OS) === 'LINUX') {
    
    // En caso de que sea Linux
    $output = shell_exec('lpstat -a');
    $lines = explode("\n", trim($output));
    foreach ($lines as $line) {
        $printer = explode(" ", $line)[0];
        $printers[] = $printer;
    }

} elseif (strtoupper(PHP_OS) === 'DARWIN') {
    // En caso de que sea macOS
    exec('lpstat -p', $output);
    // Analizar la salida del comando para obtener los nombres de las impresoras
    foreach ($output as $line) {
        if (strpos($line, 'printer ') !== false) {
            $printer = trim(substr($line, strpos($line, 'printer ') + 8));
            $printers[] = $printer;
        }
    }

} else {
    // En caso de que el sistema operativo no sea compatible
    echo 'Sistema operativo no compatible';
    exit;
}

// Obtener el valor seleccionado previamente, si existe
$selectedPrinter = isset($_SESSION['selectedPrinter']) ? $_SESSION['selectedPrinter'] : '';

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener la impresora seleccionada del formulario
    $selectedPrinter = isset($_POST['printer']) ? $_POST['printer'] : '';

    // Almacenar la impresora seleccionada en la sesi贸n
    $_SESSION['selectedPrinter'] = $selectedPrinter;
}



?>




    <form method="post" class="selectPrint" onsubmit="return false">
        <label for="printer" class="iconPrint"><i class="fa-solid fa-print"> </i></label>
        <select name="printer" id="printer" >
            <?php foreach ($printers as $printer): ?>
                <?php
                // Obtener solo el nombre de la impresora
                $printerName = explode(" ", $printer)[0];
                ?>
                <option value="<?php echo $printerName; ?>" <?php if ($selectedPrinter === $printerName) echo 'selected'; ?>><?php echo $printerName; ?></option>
            <?php endforeach; ?>
        </select>
    </form>

    <script>
        // Obtener el elemento select
        var printerSelect = document.getElementById('printer');

        // Capturar el evento de cambio
        printerSelect.addEventListener('change', function() {
            // Enviar el formulario autom谩ticamente
            this.form.submit();
        });
    </script>
    
    <?php
} catch (Throwable $e) {
    $selectedPrinter = "";
}
