<?php
include "../session.php"; 


if($role!="ADMIN"){
	header("Location:index.php");
	die();
  }
  
require "conect.php";
require '../vendor/autoload.php';

use \PhpOffice\PhpSpreadsheet\IOFactory;
use \PhpOffice\PhpSpreadsheet\cell\Coordinate;



$allowedFileType = [
'application/vnd.ms-excel',
'text/xls',
'text/xlsx',
'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
];

if (in_array($_FILES["file"]["type"], $allowedFileType)) {

$targetPath = '../subidas/' . $_FILES['file']['name'];
move_uploaded_file($_FILES['file']['tmp_name'], $targetPath);

$inputFileName = $targetPath;


/** Load $inputFileName to a Spreadsheet Object  **/
$spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileName);
$totalHojas = $spreadsheet->getSheetCount();

$datosErrores=0;



if($totalHojas>1) {
	echo 2;
	
}
else if($totalHojas==1){


	
	$hojaActual = $spreadsheet->getSheet("0");
	$nFilas = $hojaActual->getHighestDataRow();
	$lColumn = $hojaActual->getHighestDataColumn();
	$nLetra = Coordinate::columnIndexFromString($lColumn);
	$cargados=0;
	$actualizados=0;
	$valorStatus="activo";
	$valorStatusI="inactivo";
	$regActualizados=0;


	for ($iFila1=1; $iFila1<=$nFilas; $iFila1++) {

			$valorCodigo=$hojaActual->getCellByColumnAndRow(1,$iFila1);
			$valorNombre=$hojaActual->getCellByColumnAndRow(2,$iFila1);

			if ($valorCodigo=="0"||$valorCodigo==""||$valorCodigo==false||$valorNombre=="0"||$valorNombre==""||$valorNombre==false) {
				$datosErrores++;
			}

		}

		
	
		if ($datosErrores>0) {
		//Tiene errores
		echo 3;

		}
		else if ($datosErrores==0) {


			$registroAct = mysqli_query($con, "UPDATE asociados SET STATUS='$valorStatusI' WHERE STATUS != '$valorStatusI'");
			$regActualizados = mysqli_affected_rows($con);



			// Preparar la consulta para la actualización del campo STATUS
			$actualizarStatusConsulta = mysqli_prepare($con, "UPDATE asociados SET STATUS=? WHERE CODIGO=?");
			mysqli_stmt_bind_param($actualizarStatusConsulta, 'ss', $valorStatus, $valorCodigo);

			// Preparar la consulta para la actualización del campo NAME
			$actualizarNombreConsulta = mysqli_prepare($con, "UPDATE asociados SET NAME=? WHERE CODIGO=?");
			mysqli_stmt_bind_param($actualizarNombreConsulta, 'ss', $valorNombre, $valorCodigo);

			// Preparar la consulta para la inserción
			$insertarConsulta = mysqli_prepare($con, "INSERT INTO asociados (NAME, CODIGO, STATUS) VALUES(?, ?, ?)");
			mysqli_stmt_bind_param($insertarConsulta, 'sss', $valorNombre, $valorCodigo, $valorStatus);

			for ($iFila = 1; $iFila <= $nFilas; $iFila++) {
				$valorCodigo = $hojaActual->getCellByColumnAndRow(1, $iFila);
				$valorNombre = $hojaActual->getCellByColumnAndRow(2, $iFila);

				$consulta = mysqli_query($con, "SELECT * FROM asociados WHERE CODIGO='$valorCodigo'");
				$conteo = mysqli_num_rows($consulta);

				if ($conteo > 0) {
					$row = mysqli_fetch_assoc($consulta);
					$nombreExistente = $row['NAME'];

					if ($nombreExistente != $valorNombre) {
						mysqli_stmt_execute($actualizarNombreConsulta);
					}
					
					mysqli_stmt_execute($actualizarStatusConsulta);
					$cargados++;
					$regActualizados--;
					
				} else {
					mysqli_stmt_execute($insertarConsulta);
					$actualizados++;
				}
			}

			// Cerrar las consultas preparadas
			mysqli_stmt_close($actualizarStatusConsulta);
			mysqli_stmt_close($actualizarNombreConsulta);
			mysqli_stmt_close($insertarConsulta);








	  			if ($actualizados>0) {
						echo "Se han registrado ".$actualizados." nuevos usuarios<br>";
					} else {
						echo "No se han registrado nuevos usuarios<br>";
					};

					if ($cargados>0) {
						echo "ya existían registrados ".$cargados." usuarios <br>";
					}
					else {
						echo "no se han encontrado usuarios duplicados";
					}
					if ($regActualizados>0) {
						echo $regActualizados." Actualizados <br>";						
					}

					

		}


}

} else {
echo 1;

}
 ?>